﻿<%@ Page Language="C#" AutoEventWireup="true" CodeFile="Patient.aspx.cs" Inherits="Patient" MasterPageFile ="~/Registry.master" %>
<%@ Import  Namespace="System.Web.Security.AntiXss" %>

<asp:Content ID="Content1" ContentPlaceHolderID="head" Runat="Server">
    <link type = "text/css" href ="styles/StyleSheet.css"/>          
    <style type="text/css">
        .style1
        {
            width: 100%;
        }
        .style2
        {
            width: 110px;
        }
        .style3
        {
        }
        .style4
        {
            width: 8px;
        }
        .style6
        {
            width: 110px;
        }
        .style8
        {
            width: 200px;
        }
        .style9
        {
            width: 100px;
        }
        .style10
        {
            width: 110px;
        }
        .style11
        {
            width: 250px;
        }
        .style12
        {
            width: 250px;
        }
        .style13
        {
            width: 200px;
        }
        .style14
        {
            width: 120px;
        }
    </style>
</asp:Content> 


<asp:Content ID="Content2" ContentPlaceHolderID = "ContentPlaceHolder" Runat="Server" >
    <asp:ValidationSummary ID="ValidationSummaryLabKitOrder" runat="server" 
        TabIndex="1" 
        HeaderText="The page has the following data errors:" 
        DisplayMode="BulletList" 
        ShowSummary="false" 
        ValidationGroup="EFRPatient"
        ShowMessageBox="True" />
    <asp:ObjectDataSource ID="ObjectDataSourcePatient" runat="server" 
                OldValuesParameterFormatString="original_{0}" 
                SelectMethod="SelectByID"
                TypeName="VeteransAffairs.Registries.BusinessManager.EFRPatientManager"
                DataObjectTypeName="VeteransAffairs.Registries.Business.PATIENT">
                <SelectParameters>
                    <asp:QueryStringParameter DefaultValue="0" Name="id" 
                        QueryStringField="patientId" Type="String" />
                </SelectParameters>
            </asp:ObjectDataSource>
    
    <div class="breadcrumb">               
        <asp:Label SkinID="DataLabel" ID = "BreadCrumbLabel" runat="server" Text= "Patients > Patient Lookup > Patient Information > " />
                         
    </div>    

    <table>
        <tr>
            <td>
                 <asp:Panel ID="PanelPatient" runat="server" GroupingText="&nbsp;&nbsp;Patient Information&nbsp;&nbsp;" Width="100%" BorderColor="Black" >
                <asp:FormView ID="FormViewPatient" runat="server" 
                DataSourceID="ObjectDataSourcePatient" BorderColor = "Black">
                <ItemTemplate>
                    <table class="style1" >
                        <tr>
                            <td class="style10">
                                <asp:Label SkinID="DataLabel" ID="LabelforPATIENT_ICNLabel" runat="server" AssociatedControlID="PATIENT_ICNLabel">ICN:</asp:Label>
                                </td>
                            <td style="style11">
                                <asp:Label SkinID="DataLabel" ID="PATIENT_ICNLabel" runat="server" 
                                    Text='<%# AntiXssEncoder.HtmlEncode(Convert.ToString(Eval("PATIENT_ICN")), false) %>' />
                            </td>
                            <td style="style4">
                                &nbsp;</td>
                            <td class="style2" style="style6">
                                <asp:Label SkinID="DataLabel" ID="LabelforSSNLabel1" runat="server" AssociatedControlID="SSNLabel1">SSN:</asp:Label>
                                </td>
                            <td style="style8">
                                <asp:Label SkinID="DataLabel" ID="SSNLabel1" runat="server" 
                                    Text='<%# AntiXssEncoder.HtmlEncode(Convert.ToString(Eval("Snum")), false) %>' />
                            </td>
                        </tr>
                    </table>
                    <hr style= "color:Black"   />
                    <table class="style1" >
                        <tr>
                            <td class="style2">
                                <asp:Label SkinID="DataLabel" ID="LabelforFullNameLabel" runat="server" AssociatedControlID="FullNameLabel">Full Name:</asp:Label>
                                </td>
                            <td class="style3">
                                <asp:Label SkinID="DataLabel" ID="FullNameLabel" runat="server" Text='<%# AntiXssEncoder.HtmlEncode(Convert.ToString(Eval("FullName")), false) %>' />
                            </td>
                            <td class="style3">
                                &nbsp;</td>
                            <td class="style3">
                                &nbsp;</td>
                            <td class="style3">
                                &nbsp;</td>
                        </tr>
                        <tr>
                            <td class="style2">
                                <asp:Label SkinID="DataLabel" ID="LabelforSTD_INSTITUTION_IDLabel" runat="server" AssociatedControlID="STD_INSTITUTION_IDLabel">Home VAMC:</asp:Label>
                                </td>
                            <td colspan="4">
                                <asp:Label SkinID="DataLabel" ID="STD_INSTITUTION_IDLabel" runat="server" 
                                    Text='<%# AntiXssEncoder.HtmlEncode(Convert.ToString(Eval("STD_INSTITUTION.FullVisnName")), false) %>' />
                            </td>
                        </tr>
                    </table>
                    <table class="style1" >
                        <tr>
                            <td class="style10">
                                <asp:Label SkinID="DataLabel" ID="LabelforSTD_GENDER_IDLabel" runat="server" AssociatedControlID="STD_GENDER_IDLabel">Gender:</asp:Label>
                                </td>
                            <td class="style11">
                                <asp:Label SkinID="DataLabel" ID="STD_GENDER_IDLabel" runat="server" 
                                    Text='<%# AntiXssEncoder.HtmlEncode(Convert.ToString(Eval("STD_GENDER.NAME")), false) %>' />
                                
                            </td>
                            <td class="style4">
                                &nbsp;</td>
                            <td class="style6">
                                <asp:Label SkinID="DataLabel" ID="LabelforBIRTH_DATELabel" runat="server" AssociatedControlID="BIRTH_DATELabel">Birth Date:</asp:Label>
                                </td>
                            <td class="style8">
                                <asp:Label SkinID="DataLabel" ID="BIRTH_DATELabel" runat="server" 
                                    Text='<%# AntiXssEncoder.HtmlEncode(Convert.ToString(Eval("BIRTH_DATE")), false) %>' />
                            </td>
                        </tr>
                        <tr>
                            <td class="style10">
                                <asp:Label SkinID="DataLabel" ID="LabelforSTD_RACE_IDLabel" runat="server" 
                                    AssociatedControlID="STD_RACE_IDLabel">Race:</asp:Label>
                                </td>
                            <td class="style11">
                                <asp:Label SkinID="DataLabel" ID="STD_RACE_IDLabel" runat="server" 
                                    Text='<%# AntiXssEncoder.HtmlEncode(Convert.ToString(Eval("STD_RACE.NAME")), false) %>' />
                            </td>
                            <td class="style4">
                                &nbsp;</td>
                            <td class="style6">
                                <asp:Label SkinID="DataLabel" ID="LabelforDEATH_DATELabel" runat="server" AssociatedControlID="DEATH_DATELabel">Death Date:</asp:Label>
                                </td>
                            <td class="style8">
                                <asp:Label SkinID="DataLabel" ID="DEATH_DATELabel" runat="server" 
                                    Text='<%# AntiXssEncoder.HtmlEncode(Convert.ToString(Eval("DEATH_DATE")), false) %>' />
                            </td>
                        </tr>
                        <tr>
                            <td class="style10">
                                <asp:Label SkinID="DataLabel" ID="LabelforSTD_MARITALSTATUS_IDLabel" runat="server" 
                                    AssociatedControlID="STD_MARITALSTATUS_IDLabel">Marital Status:</asp:Label>
                                </td>
                            <td class="style11">
                                <asp:Label SkinID="DataLabel" ID="STD_MARITALSTATUS_IDLabel" runat="server" 
                                    Text='<%# AntiXssEncoder.HtmlEncode(Convert.ToString(Eval("STD_MARITALSTATUS.NAME")), false) %>' />
                            </td>
                            <td class="style4">
                                &nbsp;</td>
                            <td class="style6">
                                <asp:Label SkinID="DataLabel" ID="LabelforSTD_ETHNICITY_IDLabel" runat="server" AssociatedControlID="STD_ETHNICITY_IDLabel">Ethnicity:</asp:Label>
                                </td>
                            <td class="style8">
                                <asp:Label SkinID="DataLabel" ID="STD_ETHNICITY_IDLabel" runat="server" 
                                    Text='<%# AntiXssEncoder.HtmlEncode(Convert.ToString(Eval("STD_ETHNICITY.NAME")), false) %>' />
                            </td>
                        </tr>
                        <tr>
                            <td class="style10">
                                <asp:Label SkinID="DataLabel" ID="LabelforADDRESS_LINE1Label" runat="server" AssociatedControlID="ADDRESS_LINE1Label">Address:</asp:Label>
                                </td>
                            <td class="style11">
                                <asp:Label SkinID="DataLabel" ID="ADDRESS_LINE1Label" runat="server" 
                                    Text='<%# AntiXssEncoder.HtmlEncode(Convert.ToString(Eval("ADDRESS_LINE1")), false) %>' />
                            </td>
                            <td class="style4">
                                &nbsp;</td>
                            <td class="style6">
                                <asp:Label SkinID="DataLabel" ID="LabelforCITYLabel" runat="server" AssociatedControlID="CITYLabel">City:</asp:Label>
                                </td>
                            <td class="style8">
                                <asp:Label SkinID="DataLabel" ID="CITYLabel" runat="server" Text='<%# AntiXssEncoder.HtmlEncode(Convert.ToString(Eval("CITY")), false) %>' />
                            </td>
                        </tr>
                        <tr>
                            <td class="style10">
                                <asp:Label SkinID="DataLabel" ID="LabelforADDRESS_LINE2Label" runat="server" AssociatedControlID="ADDRESS_LINE2Label">Address Line 2:</asp:Label>
                                </td>
                            <td class="style11">
                                <asp:Label SkinID="DataLabel" ID="ADDRESS_LINE2Label" runat="server" 
                                    Text='<%# AntiXssEncoder.HtmlEncode(Convert.ToString(Eval("ADDRESS_LINE2")), false) %>' />
                            </td>
                            <td class="style4">
                                &nbsp;</td>
                            <td class="style6">
                                <asp:Label SkinID="DataLabel" ID="LabelforSTATELabel" runat="server" AssociatedControlID="STATELabel">State:</asp:Label>
                                </td>
                            <td class="style8">
                                <asp:Label SkinID="DataLabel" ID="STATELabel" runat="server" Text='<%# AntiXssEncoder.HtmlEncode(Convert.ToString(Eval("STATE")), false) %>' />
                            </td>
                        </tr>
                        <tr>
                            <td class="style10">
                                <asp:Label SkinID="DataLabel" ID="LabelforADDRESS_LINE3Label" runat="server" AssociatedControlID="ADDRESS_LINE3Label">Address Line 3:</asp:Label>
                                </td>
                            <td class="style11">
                                <asp:Label SkinID="DataLabel" ID="ADDRESS_LINE3Label" runat="server" 
                                    Text='<%# AntiXssEncoder.HtmlEncode(Convert.ToString(Eval("ADDRESS_LINE3")), false) %>' />
                            </td>
                            <td class="style4">
                                &nbsp;</td>
                            <td class="style6">
                                <asp:Label SkinID="DataLabel" ID="LabelforPOSTAL_CODELabel" runat="server" AssociatedControlID="POSTAL_CODELabel">Postal Code:</asp:Label>
                                </td>
                            <td class="style8">
                                <asp:Label SkinID="DataLabel" ID="POSTAL_CODELabel" runat="server" 
                                    Text='<%# AntiXssEncoder.HtmlEncode(Convert.ToString(Eval("POSTAL_CODE")), false) %>' />
                            </td>
                        </tr>
                        <tr>
                            <td class="style10">
                                <asp:Label SkinID="DataLabel" ID="LabelforCOUNTYLabel" runat="server" AssociatedControlID="COUNTYLabel">County:</asp:Label>
                                </td>
                            <td class="style11">
                                <asp:Label SkinID="DataLabel" ID="COUNTYLabel" runat="server" 
                                    Text='<%# AntiXssEncoder.HtmlEncode(Convert.ToString(Eval("COUNTY")), false) %>' />
                            </td>
                            <td class="style4">
                                &nbsp;</td>
                            <td class="style6">
                                <asp:Label SkinID="DataLabel" ID="LabelforCOUNTRYLabel" runat="server" AssociatedControlID="COUNTRYLabel">Country:</asp:Label>
                            </td>
                            <td class="style8">
                                <asp:Label SkinID="DataLabel" ID="COUNTRYLabel" runat="server" 
                                    Text='<%# AntiXssEncoder.HtmlEncode(Convert.ToString(Eval("COUNTRY")), false) %>' />
                            </td>
                        </tr>
                    </table>
                    <hr style= "color:Black" />
                    <table class="style1" >
                        <tr>
                            <td class="style10">
                                <asp:Label SkinID="DataLabel" ID="LabelforHOME_PHONELabel" runat="server" AssociatedControlID="HOME_PHONELabel">Home Phone:</asp:Label>
                                </td>
                            <td class="style11">
                                <asp:Label SkinID="DataLabel" ID="HOME_PHONELabel" runat="server" 
                                    Text='<%# AntiXssEncoder.HtmlEncode(Convert.ToString(Eval("HOME_PHONE")), false) %>' />
                            </td>
                            <td class="style4">
                            </td>
                            <td class="style8">
                                <asp:Label SkinID="DataLabel" ID="LabelforWORK_PHONELabel" runat="server" AssociatedControlID="WORK_PHONELabel">Work Phone:</asp:Label>
                                </td>
                            <td class="style8">
                                <asp:Label SkinID="DataLabel" ID="WORK_PHONELabel" runat="server" 
                                    Text='<%# AntiXssEncoder.HtmlEncode(Convert.ToString(Eval("WORK_PHONE")), false) %>' />
                            </td>
                        </tr>
                        
                    </table>
                    <hr style= "color:Black" />
                </ItemTemplate> 
                </asp:FormView>
                <br />   
             <asp:Panel ID="PanelPatientAlternativeInfo" runat="server" GroupingText="&nbsp;&nbsp;Patient Alternate Contact Information&nbsp;&nbsp;" Width="100%">
                        
            <table align= "left" class="style1" cellpadding = "5" cellspacing = "5" border="0">
            
            <tr style = "height:20px;">
                <td class="style3">
                    <asp:Label SkinID="DataLabel" runat="server" ID="labelStreetAddress1" Text="Alternate Street Address 1:" AssociatedControlID="txtStreetAddress1"></asp:Label></td>
                <td>
                    <asp:TextBox ID="txtStreetAddress1" runat="server" Width="400px" ></asp:TextBox>
                            
                 </td>
            </tr>
            
            <tr style = "height:20px;">
                <td class="style3">
                    <asp:Label SkinID="DataLabel" runat="server" ID="labelStreetAddress2" Text="Alternate Street Address 2:" AssociatedControlID="txtStreetAddress2"></asp:Label></td>
                <td>
                    <asp:TextBox ID="txtStreetAddress2" runat="server" Width="400px" ></asp:TextBox>

                </td>
            </tr>
            
            <tr style = "height:20px;">
                <td class="style3">
                    <asp:Label SkinID="DataLabel" runat="server" ID="labelStreetAddress3" Text="Alternate Street Address 3:" AssociatedControlID="txtStreetAddress3" Width="300px"></asp:Label></td>
                <td>
                    <asp:TextBox ID="txtStreetAddress3" runat="server" Width="400px" ></asp:TextBox> 
                </td>
            </tr>
            
            <tr style = "height:20px;">
                <td class="style3">
                    <asp:Label SkinID="DataLabel" runat="server" ID="labelAddressCity" Text="Alternate City:" AssociatedControlID="txtAddressCity"></asp:Label></td>
                <td style="margin-left: 40px">
                    <asp:TextBox ID="txtAddressCity" runat="server" width="400px" MaxLength="100"></asp:TextBox>
                </td>
            </tr>
            
            <tr style = "height:20px;">
                <td class="style3">
                    <asp:Label SkinID="DataLabel" runat="server" ID="labelAddressState" Text="Alternate State:" AssociatedControlID="txtAddressState"></asp:Label></td>
                <td style="margin-left: 40px">
                    <asp:TextBox ID="txtAddressState" runat="server" width="400px" MaxLength="100"></asp:TextBox>
                </td>
            </tr>
            
            <tr style = "height:20px;">
                <td class="style3">
                    <asp:Label SkinID="DataLabel" runat="server" ID="labelAddressZip" Text="Alternate Zip:" AssociatedControlID="txtAddressZip" Width="300px"></asp:Label></td>
                <td>
                    <asp:TextBox ID="txtAddressZip" runat="server" width="400px" MaxLength="100"></asp:TextBox> 
                </td>
            </tr>
            
            <tr style = "height:20px;">
                <td class="style3" >
                    <asp:Label SkinID="DataLabel" runat="server" ID="labelAddressCountry" Text="Alternate Country:" AssociatedControlID="txtAddressCountry"></asp:Label></td>
                <td style="margin-left: 40px">
                    <asp:TextBox ID="txtAddressCountry" runat="server" width="400px" MaxLength="100"></asp:TextBox>
                </td>
            </tr>
            
            <tr style = "height:20px;">
                <td class="style3" >
                    <asp:Label SkinID="DataLabel" runat="server" ID="labelHomePhone" 
                        Text="Alternate Home Telephone:" 
                        AssociatedControlID="txtHomePhone">
                    </asp:Label></td>
                <td style="margin-left: 40px">
                    <asp:TextBox ID="txtHomePhone" runat="server" 
                        width="400px" 
                        MaxLength="100">
                    </asp:TextBox>
                    <br />
                    <asp:RegularExpressionValidator ID = "RegularExpressionValidatorTextBoxTelephone" runat = "server" 
                        ControlToValidate = "txtHomePhone"
                        ErrorMessage = "Phone field can only contain numbers and the following characters: + - ( ) x" 
                        Display="Dynamic"
                        EnableClientScript="true"
                        SetFocusOnError="true"
                        ValidationExpression = "^(\(?\+?[0-9]*\)?)?[x0-9_\.\- \(\)]*(x)*[0-9_\.\- \(\)]+$" 
                        ValidationGroup = "EFRPatient">
                    </asp:RegularExpressionValidator>
                </td>
            </tr>
            <tr style = "height:20px;">
                <td class="style3" >
                    <asp:Label SkinID="DataLabel" runat="server" ID="label2" 
                        Text="Alternate Work Telephone:" 
                        AssociatedControlID="txtWorkPhone">
                    </asp:Label></td>
                <td style="margin-left: 40px">
                    <asp:TextBox ID="txtWorkPhone" runat="server" 
                        width="400px" 
                        MaxLength="100">
                    </asp:TextBox>
                    <br />
                    <asp:RegularExpressionValidator ID = "RegularExpressionValidator1" runat = "server" 
                        ControlToValidate = "txtWorkPhone"
                        ErrorMessage = "Phone field can only contain numbers and the following characters: + - ( ) x" 
                        Display="Dynamic"
                        EnableClientScript="true"
                        SetFocusOnError="true"
                        ValidationExpression = "^(\(?\+?[0-9]*\)?)?[x0-9_\.\- \(\)]*(x)*[0-9_\.\- \(\)]+$" 
                        ValidationGroup = "EFRPatient">
                    </asp:RegularExpressionValidator>
                </td>
            </tr>
            <tr style = "height:20px;">
                <td class="style3" >
                    <asp:Label SkinID="DataLabel" runat="server" ID="label1" 
                        Text="Alternate Mobile Telephone:" 
                        AssociatedControlID="txtMobilePhone">
                    </asp:Label>
                </td>
                <td style="margin-left: 40px">
                    <asp:TextBox ID="txtMobilePhone" runat="server" 
                        width="400px" 
                        MaxLength="100">
                    </asp:TextBox>
                    <br />
                    <asp:RegularExpressionValidator ID = "RegularExpressionValidator2" runat = "server" 
                        ControlToValidate = "txtMobilePhone"
                        ErrorMessage = "Phone field can only contain numbers and the following characters: + - ( ) x" 
                        Display="Dynamic"
                        EnableClientScript="true"
                        SetFocusOnError="true"
                        ValidationExpression = "^(\(?\+?[0-9]*\)?)?[x0-9_\.\- \(\)]*(x)*[0-9_\.\- \(\)]+$" 
                        ValidationGroup = "EFRPatient">
                    </asp:RegularExpressionValidator>
                </td>
            </tr>
            <tr style = "height:20px;">
                <td class="style3" >
                </td>
                <td style="margin-left: 40px">
                    <asp:Panel ID="PanelPreferredAlternateTelephoneNumber" runat="server" 
                        GroupingText = "&nbsp;&nbsp;Preferred Alternate Telephone Number&nbsp;&nbsp;"  
                        Width="395px">
                        <asp:RadioButtonList ID="RadioButtonListPreferredAlternateTelephoneNumber" runat="server"  
                            RepeatDirection="Horizontal"
                            Width="390px">
                            <asp:ListItem Value="1">Home</asp:ListItem>
                            <asp:ListItem Value="2">Work</asp:ListItem>
                            <asp:ListItem Value="3">Mobile</asp:ListItem>
                        </asp:RadioButtonList>
                    </asp:Panel>                    
                </td>
            </tr>
            
            
            <tr style = "height:20px;">
                <td class="style3" >
                    <asp:Label SkinID="DataLabel" runat="server" ID="label3" Text="Email Address:" AssociatedControlID="txtEmailAddress"></asp:Label></td>
                <td style="margin-left: 40px">
                    <asp:TextBox ID="txtEmailAddress" runat="server" width="400px" MaxLength="100"></asp:TextBox>
                     <asp:RegularExpressionValidator ID = "PatientEMailValidator" runat = "server" ControlToValidate = "txtEmailAddress"
                                ErrorMessage = "* Invalid e-mail" ValidationExpression = "^\s*\w+([-+.']\w+)*@\w+([-.]\w+)*\.\w+([-.]\w+)*\s*$" ValidationGroup = "EFRPatient"></asp:RegularExpressionValidator>
                                    
                </td>
            </tr>
            
            
        </table>
                
                
                    </asp:Panel> 
                </asp:Panel>  
            </td> 
        </tr>
        <tr align = "center">
            <td>
                 <br />
                 <asp:Button runat = "server" ID = "SaveButton" 
                    Text = "Save" 
                    Width = "130px" 
                    ValidationGroup = "EFRPatient" 
                    OnClick = "SaveButton_Click" 
                    UseSubmitBehavior = "true" />        
                 
                 <asp:Button runat = "server" Text = "Cancel" Width = "130px" ID = "CancelButton" OnClick="CancelButton_OnClick" UseSubmitBehavior = "false" CssClass = "cancel" />
            </td>            
        </tr>
     </table>  
</asp:Content> 